<?php

# imgur Uploader (v3.0.1)
# Made only for educational purposes
# (c) 20161209 nggit

$url       = 'https://api.imgur.com/3/image.json'; // API endpoints, info: https://api.imgur.com/endpoints/image#image-upload
$client_id = 'd4fc5abb11c0ac3'; // Get client_id here: https://api.imgur.com/#registerapp

switch ($_SERVER['QUERY_STRING']) {
    case 'upload':
        if ($file = isset($_FILES['file']) ? $_FILES['file'] : false) {
            if ($file['error'] == UPLOAD_ERR_NO_FILE) {
                exit('Nothing to upload?');
            }
            if ($file['size'] > 1000000 || $file['error'] == UPLOAD_ERR_INI_SIZE) {
                exit('Sorry, your file is too large');
            }
            if (!exif_imagetype($file['tmp_name'])) {
                exit('File is not an image');
            }
            if ($file['error'] == UPLOAD_ERR_OK) {
                $fh   = fopen($file['tmp_name'], 'r');
                $read = fread($fh, $file['size']);
                fclose($fh);
                $post = array(
                            'image' => base64_encode($read)
                        );
                $ch   = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                                                         'Authorization: Client-ID '.$client_id
                                                     ));
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $json = curl_exec($ch); // Response, info: https://api.imgur.com/#responses
                curl_close($ch);
                // $image = json_decode($json, true); // Array
                $image = json_decode($json); // Object

                // var_dump($image);

                // $original = $image['data']['link']; // Array-style
                $original = $image->data->link; // Object-style
                $thumb    = substr_replace($original, 't', -4, 0); // t = Small Thumbnail, info: https://api.imgur.com/models/image
                echo '<img src="'.$thumb.'" alt="'.$image->data->id.'" /><br /><a href="'.$original.'">'.$original.'</a>'; // Example

                // ...
            }
            else {
                echo 'Upload was failed. Error code: '.$file['error'];
            }
        }
        break;
    default:
        echo '<!DOCTYPE html>'."\n"
            .'<html>'."\n"
            .'    <head>'."\n"
            .'        <title>imgur Uploader</title>'."\n"
            .'    </head>'."\n"
            .'    <body>'."\n"
            .'        <div>'."\n"
            .'            <h2>imgur Uploader (v3.0.1)</h2>'."\n"
            .'            <p>Upload an image to imgur.com.</p>'."\n"
            .'        </div>'."\n"
            .'        <form action="'.basename($_SERVER['SCRIPT_NAME']).'?upload" method="post" enctype="multipart/form-data">'."\n"
            .'            <div>'."\n"
            .'                <label for="file">Select an image file to upload:</label>'."\n"
            .'                <input type="file" name="file"><br />'."\n"
            .'                <input type="submit" value="Upload">'."\n"
            .'            </div>'."\n"
            .'        </form>'."\n"
            .'        <div>'."\n"
            .'            <p>&copy; 20161209 <a href="http://anggit.com">nggit</a></p>'."\n"
            .'        </div>'."\n"
            .'    </body>'."\n"
            .'</html>';
}
